//===============================================================================================
// Put the generic feedback functions in here.
//===============================================================================================

var kMaxComment = 1024;
	// Number of characters allowed in a comment
		
function zOption( name, subtopics, addStates )
{
	this.name = name;
	this.subtopics = (subtopics) ? subtopics : null;
	this.addStates = (addStates) ? true : false;
}

// Problem description 
// This is the problem description drop down. The new purpose of this drop down is to
// understand urgency/priority
gProblems = new Array(
	new zOption( "I'd like to tell you about..." ),
	new zOption( "Help Content" ),
	new zOption( "A problem or bug" ),
	new zOption( "An enhancement" ),
	new zOption( "A positive experience" ),
	new zOption( "Other" )
);

gAreas = new Array(
	new zOption( "My comment is about...TurboTax Help Content",
		new Array( "Help was...",
					"Unavailable - could not find my help topic",
					"Too difficult to understand",
					"Inaccurate or out of date",
					"Incomplete (missing steps, etc.)",
					"Not relevant to my situation",
					"Not working correctly (broken links, blank pages, etc.)",
					"Other") ),
	new zOption( "My comment is about...Using TurboTax" ),
	new zOption( "My comment is about...Where Do I Enter?" ),
	new zOption( "My comment is about...The screen I was on" ),
	new zOption( "My comment is about...An idea or suggestion" )
);

gHelpTopics = new Array(
				new zOption("Which area can we improve?"),
				new zOption("Updating TurboTax"),
				new zOption("Downloading products"),
				new zOption("Transferring from last year's return"),
				new zOption("Importing financial information"),
				new zOption("Entering my tax information"),
				new zOption("E-filing my return"),
				new zOption("Printing my return"),
				new zOption("I have positive things to say about TurboTax!"),
				new zOption("Other")
);

//-----------------------------------------------------------------------------------------------
function appendSelect( id, subtopicId, options, optionsName )
{
	var s = '<select id="' + id + '"';
	if( subtopicId ) s += ' onchange="onSubtopic(\''+ id + '\',\'' + subtopicId + '\',' + optionsName + ')"';
	s += '>';
	
	var cnt = options.length;
	for( var i=0; i<cnt; ++i )
	{
		s += '<option value="';
		if (id == "problemType")
			s += options[i].name;
		else
			s += (i>0) ? options[i].name : "";
		s += '">';
		s += options[i].name;
		s += '</option>';		
	}
	
	s += '</select>';

	document.write(s);
}

//-----------------------------------------------------------------------------------------------
function createSubtopics( e, option )
{
	var subtopics = option.subtopics;
	
	// Remove any existing options
	var cnt = e.options.length;
	for( var i=cnt-1; i>=0; --i ) e.options.remove(i);
	
	//var opt = document.createElement("option");
	//e.options.add(opt);
	//opt.innerText = "Specifically, my feedback is about...";
	//opt.value = "";
	
	var cnt = subtopics.length;
	var opt=null;
	for( var i=0; i<cnt; ++i )
	{
		opt = document.createElement("option");
		e.options.add(opt);
		opt.innerText = subtopics[i];
		if (i > 0)		
			opt.value = subtopics[i];
		else
			opt.value = "";
	}
	e.selectedIndex=0;
	
	if( option.addStates && gFeedback.installedStates )
	{
		cnt = gFeedback.installedStates.length;
		for( i=0; i<cnt; ++i )
		{
			opt = document.createElement("option");
			e.options.add(opt);
			
			// Eliminate the year if present in the state name
			var st = gFeedback.installedStates[i].replace( /^[0-9 ]*(.*)/, "$1" );
			opt.innerText = st;		
			opt.value = st;
		}	
	}
	
	e.options[0].selected = true;
}

//-----------------------------------------------------------------------------------------------
function saveFeedback()
	// Collect the feedback field values
{
	var f = document.getElementById("comments");
	var defaultComment = "How can we improve?";  // tail end of the default comments.
	var defaultIndex =0;
	if( f ) 
	{
		defaultIndex = f.value.indexOf(defaultComment);
		if (defaultIndex > 0)
		{
			if ((defaultIndex + defaultComment.length) >= f.value.length)
				gFeedback.comment = "";
			else
				gFeedback.comment = f.value; //include the original stuff in the comments.
		}
		else
			gFeedback.comment = f.value;
	}
	
	f = document.getElementById("problemType");
	if( f ) 
	{
		gFeedback.problemType = f.value.substring(f.value.indexOf(".")+3);
	}

	f = document.getElementById("topic");
	if( f ) gFeedback.topic = f.value;

	f = document.getElementById("subtopic");
	if( f ) gFeedback.subtopic = f.value;
	
	f = document.getElementById("NameInput");
	if ( f ) gFeedback.contactName = f.value;
	
	f = document.getElementById("PhoneInput");
	if ( f ) gFeedback.contactPhone = f.value;
	
	f = document.getElementById("EMailInput");
	if ( f ) gFeedback.contactEMail = f.value;
}

//-----------------------------------------------------------------------------------------------
function onSubtopic( id, subtopicId, options )
{
	// Coordinate the subtopic picklist
	var cnt = options.length;	

	var l = document.getElementById( id );
	if( !l ) return;
	if( l.selectedIndex >= cnt ) return;
	var comboB = document.getElementById( "topicTable" );
	if ( l.selectedIndex == 2 )
	{
		// Where do I enter kludge
		if ( comboB )
		{
			comboB.style.visibility = "hidden";
			comboB.style.display = "none";
			//hide( comboB );
		}
	}
	else
	{
		comboB.style.visibility = "visible";
		comboB.style.display = "block";
		//show( comboB );
	}
		
	var sub = document.getElementById( subtopicId );
	var subTable = document.getElementById( "subtopicTable" );
	if( !sub ) return;
	
	sub.selectedIndex = 0;
		
	// Check if the selected topic has sub topics
	var opt = options[ l.selectedIndex ];
	if( !opt.subtopics )
	{
		subTable.style.visibility = "hidden";
  		subTable.style.display = "none";
		//hide( sub );
		return;
	}

	createSubtopics( sub, opt )
	subTable.style.visibility = "visible";
  	subTable.style.display = "block";
	//show( sub );

	// In this case, the subtopic is the third combo box.  Therefore we shouldn't set focus to it.
	//sub.focus();
}

//-----------------------------------------------------------------------------------------------
function onResize()
	// Handle the resizing of the window
{
	// Position the watermark at the bottom of the page
	var wm = document.getElementById("watermark");
	if( wm )
	{
		var wmY = getWindowHeight() - wm.offsetHeight;
		wm.style.top = wmY + "px";
		show( wm );
	}
}

//-----------------------------------------------------------------------------------------------
function onLimitComment(e)
	// Limit the characters within a textarea
{
	if( e && e.value.length > kMaxComment ) e.value = e.value.substr( 0, kMaxComment );
}

function onFocusComment(e)
	// Limit the characters within a textarea
{
	e.select();
}

//-----------------------------------------------------------------------------------------------
function onClose()
{ 
	if (gAppFeedback == true)
		parent.onCancel();
	else
		window.close(); 
}
